import apple2.*;

public class List
{
	public static void main(String args[])
	{
		int io_buffer, ref_num, bytes_read, machine_id;
		boolean lowercase;
		String list_file;
		byte data_buffer[] = new byte[512];

		machine_id = vm02.peekByte(0xBF98);
		if ((machine_id & 0x02) == 0x02)
			vm02.call(0, 0xC300);
		lowercase = ((machine_id & 0x82) != 0);

		conio.println("PRESS ANY KEY TO STOP/START LISTING");
		io_buffer = ProDOS.allocIOBuffer();
		list_file = "README.TXT";
		if (args.length == 1)
			list_file = args[0];
		ref_num = ProDOS.open(list_file, io_buffer);
		if (ref_num < 0)
		{
			conio.print("Open file error: ");
			conio.println(-ref_num);
			return;
		}
		do
		{
			bytes_read = ProDOS.read(ref_num, data_buffer);
			if (bytes_read > 0)
			{
				int i, b, h;
				for (i = 0; i < bytes_read; i++)
				{
					b = data_buffer[i];
					switch (b)
					{
						case '\n':
							vm02.call('\r'|0x80, 0xFDED);
							break;
						case 9: // TAB
							h = vm02.peekByte(0x0024);
							do {
								vm02.call(0xA0, 0xFDED);
							} while (((++h) & 0x07) != 0);
							break;
						default:
							if (!lowercase)
								if (b >= 0x60) b -= 0x20;
							vm02.call(b|0x80, 0xFDED);
					}
					if (conio.keyPressed())
					{
						conio.getKey();
						conio.getKey();
					}
				}
			}
		} while (bytes_read == data_buffer.length);
		ProDOS.close(ref_num);
		ProDOS.freeIOBuffer(io_buffer);
		if (args.length == 0)
			ProDOS.destroy("STARTUP");
	}
}